/**************************************************************************************************
 * Source file for Keyboard driver.
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 **************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **********************************************************************************************//*!
 *************************************************************************************************/

/************************************************************************************
*************************************************************************************
* Includes
*************************************************************************************
************************************************************************************/
#if defined(CW) 
#include "derivative.h"
#elif defined(IAR)
#include "PortConfig.h"
#else 
#error "No valid development tool defined"
#endif

#include "Keyboard.h"
#include "Phy.h"
#include "Interrupt.h"

#if TRUE == gKeyboardSupported_d

/************************************************************************************
*************************************************************************************
* Private macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/


/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
static keyboardCallback_t pKeyboardCallback; 
keyboardPressed_t gKeyboard_PortValue;  

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*  	Keyboard_Init
*
* The purpose of this function is to set the initial status of the port working as Keyboard  
* CallBack function specified as a parameter
*
************************************************************************************/ 

    keyboardErr_t	Keyboard_Init(keyboardCallback_t pKeyboardCallbackinit){
      	
      if(NULL == pKeyboardCallbackinit){
        return gKeyboardErrorNullPointer_c;
      }
  	
        /*Initialize here*/
         
        /* Enable interrupts for Keyboard ports */
        /*Keyboard1 (PORTA)*/
        NVIC_EnableIRQ(gKeyboard_Keyboard1IrqNo_c);                                
        
        /*Keyboard2 (PORTD)*/
        //NVIC_EnableIRQ(gKeyboard_Keyboard2IrqNo_c);                           
              
        /*Keyboard3 and Keyboard4 (PORTD)*/
        NVIC_EnableIRQ(gKeyboard_Keyboard3n4IrqNo_c);                           
    
        /* Enable module clocks */
        /*Both port clocks initialized*/
       // gKeyboard_ClkGatingReg_c |= (gKeyboard1_ClkGatingBit_c | gKeyboard2_ClkGatingBit_c);  
        gKeyboard_ClkGatingReg_c |= (gKeyboard1_ClkGatingBit_c | gKeyboard3n4_ClkGatingBit_c);  
        
        /* Initialization of Port Control registers */
        /*Keyboard 1*/
        gKeyboard_Keyboard1PinCtrlReg_c = gKeyboardxControl_ClearRegister_c;                                        
	                        #if (gKeyboardFallingEdge_c)   
                                 gKeyboard_Keyboard1PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqFallingEdge_Func_c));        
                                #elif (gKeyboardRisingEdge_c)
                                 gKeyboard_Keyboard1PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                 
                                 PORT_PCR_IRQC(gKeyboard_PinIrqRisingEdge_Func_c));       
                                #endif
      
      /*Keyboard 2 unimplemented*/
      /*  gKeyboard_Keyboard2PinCtrlReg_c = gKeyboardxControl_ClearRegister_c;                                        
	                        #if (gKeyboardFallingEdge_c)   
                                 gKeyboard_Keyboard2PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqFallingEdge_Func_c));         
                                #elif (gKeyboardRisingEdge_c)
                                 gKeyboard_Keyboard2PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqRisingEdge_Func_c));        
                                #endif
      */
       /*Keyboard 3*/                          
      gKeyboard_Keyboard3PinCtrlReg_c = gKeyboardxControl_ClearRegister_c;                                        
	                        #if (gKeyboardFallingEdge_c)   
                                 gKeyboard_Keyboard3PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqFallingEdge_Func_c));         
                                #elif (gKeyboardRisingEdge_c)
                                 gKeyboard_Keyboard3PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqRisingEdge_Func_c));        
                                #endif
      /*Keyboard 4*/                           
      gKeyboard_Keyboard4PinCtrlReg_c = gKeyboardxControl_ClearRegister_c;                                        
	                        #if (gKeyboardFallingEdge_c)   
                                 gKeyboard_Keyboard4PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqFallingEdge_Func_c));         
                                #elif (gKeyboardRisingEdge_c)
                                 gKeyboard_Keyboard4PinCtrlReg_c |=(PORT_PCR_MUX(gKeyboard_PinCtrlAltFunc_c) | PORT_PCR_ISF_MASK |
                                 PORT_PCR_PE_MASK | PORT_PCR_PS_MASK |                  
                                 PORT_PCR_IRQC(gKeyboard_PinIrqRisingEdge_Func_c));        
                                #endif
        
        /* pins direction -> INPUT (PDD&=~0x1000) */
	gKeyboard1_PortDataDirReg_c &= (uint32_t)~(uint32_t)(gKeyboard_Keyboard1Pin_c);       
	//gKeyboard2_PortDataDirReg_c &= (uint32_t)~(uint32_t)(gKeyboard_Keyboard2Pin_c); 
        gKeyboard3_PortDataDirReg_c &= (uint32_t)~(uint32_t)(gKeyboard_Keyboard3Pin_c);
        gKeyboard4_PortDataDirReg_c &= (uint32_t)~(uint32_t)(gKeyboard_Keyboard4Pin_c);
        
  	pKeyboardCallback = pKeyboardCallbackinit;
        
      return gKeyboardErrorNoError_c;
  
  }

/************************************************************************************
* Keyboard interrupt
*
* The purpose of this interrupt is to call the Callback  
* 
************************************************************************************/  

  /*PORTA ISR*/
  void Keyboard1_Interrupt (void){
    
      /*Clear ISF Flag*/
      gKeyboard_Keyboard1PinCtrlReg_c |=PORT_PCR_ISF_MASK ; 
      /*gKeyboard_PortValue=0 indicates PORTA event in the CallBack*/
      gKeyboard_PortValue = 1;                               
      pKeyboardCallback(gKeyboard_PortValue);
    }     

  /*PORTD ISR*/
  //void Keyboard2_Interrupt (void){                                            
    void Keyboard3n4_Interrupt (void){
  
      /*Need to check here if the ISR was entered by SW3, SW4 or by a PHY event*/
     
     /*Interrupt was entered by Keyboard2 (SW2) pressed, call CallBack*/
      //if((gKeyboard_Keyboard2PinCtrlReg_c & PORT_PCR_ISF_MASK))               
    if((gKeyboard_Keyboard3PinCtrlReg_c & PORT_PCR_ISF_MASK)) 
      {
      /*Clear ISF Flags*/
      //gKeyboard_Keyboard2PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
        gKeyboard_Keyboard3PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
        gKeyboard_Keyboard4PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
      /*gKeyboard_PortValue=1 indicates PORTD event in the CallBack*/     
      gKeyboard_PortValue = 3;                
      pKeyboardCallback(gKeyboard_PortValue);
      }
    
    if((gKeyboard_Keyboard4PinCtrlReg_c & PORT_PCR_ISF_MASK)) 
      {
      /*Clear ISF Flags*/
      //gKeyboard_Keyboard2PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
        gKeyboard_Keyboard3PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
        gKeyboard_Keyboard4PinCtrlReg_c |=PORT_PCR_ISF_MASK ;                   
      /*gKeyboard_PortValue=1 indicates PORTD event in the CallBack*/     
      gKeyboard_PortValue = 4;                
      pKeyboardCallback(gKeyboard_PortValue);
      }

      
      /*Interrupt was entered by an event in other PORTD pin*/
      /*This means activity in DIO0(PTD7), DIO1(PTD6) for which we need to call the Phy*/
      
      else
      {
      /*Call Phy ISR*/     
      /*Inside Phy_ISR it is determined what pin caused the Event*/
      Phy_ISR();                        
      }
       

  }                                                     

#else                            /* FALSE == gKeyboardSupported_d */

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*  Keyboard_Init
*
* The purpose of this function is to set the initial status of the Keyboard (PORT) module  
*
************************************************************************************/ 


  keyboardErr_t	Keyboard_Init(keyboardCallback_t pKeyboardCallbackinit){
     
     (void)pKeyboardCallbackinit; 	
     return gKeyboardErrorNoError_c;
  
  }

/************************************************************************************
* Keyboard interrupt
*
* The purpose of this interrupt is to call the callback. 
* 
************************************************************************************/ 
    /*PORTA ISR*/
  void Keyboard1_Interrupt (void){
    
     /*dummy function*/ 
    }     

    /*PORTD ISR*/
  //void Keyboard2_Interrupt (void){                                            
    void Keyboard3n4_Interrupt (void){
    /*dummy function*/ 
  }

#endif

/*************************************************************************************************/
